/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class PLSqlInvoker {
    private static Hashtable<String, Integer> typeMappingTable = null;
    private final int ORACLE_CURSOR_TYPE = -10;

    public void invokeProcedure(Connection aCon, String aName, Object aParam) throws SQLException {
        Object[] lParams = new Object[]{aParam};
        this.invokeProcedure(aCon, aName, lParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeProcedure(Connection aCon, String aName, Object[] aParams) throws SQLException {
        Statement lCallableStatement = null;
        try {
            lCallableStatement = this.getCallableStatementFor(aCon, aName, aParams.length, false);
            for (int i = 0; i < aParams.length; ++i) {
                lCallableStatement.setObject(i + 1, aParams[i], this.getJdbcTypeFor(aParams[i].getClass().getName()));
            }
            lCallableStatement.execute();
        }
        finally {
            if (lCallableStatement != null) {
                lCallableStatement.close();
            }
        }
    }

    public Object invokeFunction(Connection aCon, String aName, Object aParam, String aReturnTypeClass) throws SQLException {
        Object[] lParams = new Object[]{aParam};
        return this.invokeFunction(aCon, aName, lParams, aReturnTypeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeFunction(Connection aCon, String aName, Object[] aParams, String aReturnTypeClass) throws SQLException {
        Statement lCallableStatement = null;
        try {
            lCallableStatement = this.getCallableStatementFor(aCon, aName, aParams.length, true);
            lCallableStatement.registerOutParameter(1, this.getJdbcTypeFor(aReturnTypeClass));
            for (int i = 0; i < aParams.length; ++i) {
                lCallableStatement.setObject(i + 2, aParams[i], this.getJdbcTypeFor(aParams[i].getClass().getName()));
            }
            lCallableStatement.execute();
            Object object = lCallableStatement.getObject(1);
            return object;
        }
        finally {
            if (lCallableStatement != null) {
                lCallableStatement.close();
            }
        }
    }

    public Object[] invokeRefTypeFunction(Connection aCon, String aName, Object[] aParams, String aReturnTypClass) throws SQLException {
        CallableStatement lCall = this.getCallableStatementFor(aCon, aName, aParams.length, true);
        lCall.registerOutParameter(1, -10);
        lCall.execute();
        ResultSet lRs = (ResultSet)lCall.getObject(1);
        lRs.close();
        lCall.close();
        return null;
    }

    private CallableStatement getCallableStatementFor(Connection aCon, String aName, int aInCount, boolean aIsFunction) throws SQLException {
        StringBuffer lStmt = new StringBuffer();
        if (aIsFunction) {
            lStmt.append("{ ? = call ");
        } else {
            lStmt.append("{ call ");
        }
        lStmt.append(aName);
        for (int i = 0; i < aInCount; ++i) {
            if (i == 0) {
                lStmt.append("(?");
                continue;
            }
            lStmt.append(", ?");
        }
        if (aInCount > 0) {
            lStmt.append(") }");
        } else {
            lStmt.append("}");
        }
        return aCon.prepareCall(lStmt.toString());
    }

    private int getJdbcTypeFor(String pClassName) throws SQLException {
        Integer lType = this.getTypeMappingTable().get(pClassName);
        if (lType != null) {
            return lType;
        }
        throw new SQLException("Kein JDBC-Typ-Mapping definiert f\u00fcr Klasse [" + pClassName + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<String, Integer> getTypeMappingTable() {
        if (typeMappingTable == null) {
            PLSqlInvoker pLSqlInvoker = this;
            synchronized (pLSqlInvoker) {
                if (typeMappingTable == null) {
                    this.initializeTypeMappingTable();
                }
            }
        }
        return typeMappingTable;
    }

    private void initializeTypeMappingTable() {
        typeMappingTable = new Hashtable();
        typeMappingTable.put("java.lang.String", new Integer(12));
        typeMappingTable.put("java.lang.Integer", new Integer(4));
        typeMappingTable.put("java.lang.Long", new Integer(4));
        typeMappingTable.put("java.lang.Float", new Integer(6));
        typeMappingTable.put("java.lang.Double", new Integer(8));
        typeMappingTable.put("java.sql.Date", new Integer(91));
        typeMappingTable.put("java.sql.Time", new Integer(92));
        typeMappingTable.put("java.sql.Timestamp", new Integer(93));
    }
}

