/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.document.DaleSegment;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.model.dale.VEEBReportModel;
import dguv.daleuv.report.model.dale.VEEBReportModelSubreport;
import dguv.daleuv.report.model.dale.VerbrennungModel;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.PartModelBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.document.UniDavDocumentException;
import java.util.Enumeration;

public class VEEB_ReportModelBuilder
extends DaleAbstractReportModelBuilder {
    public VEEB_ReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        super(aNachrichtentyp);
    }

    @Override
    public ReportModel buildModel(GVContext aGVContext) {
        VEEBReportModel lModel = new VEEBReportModel();
        try {
            this.fuelleKopfUndFussZeile(aGVContext, lModel);
            DaleDocument lDaleDocument = (DaleDocument)aGVContext.getUniDavDocument();
            PartModelBuilder.fuelleEbMasterKopfBereich(lDaleDocument, lModel.getKopfbereichModel(), aGVContext.getNachrichtenkennung());
            this.fuelleHauptteil(lDaleDocument, lModel.getVeebReportModelSubreport());
            PartModelBuilder.fuelleAbsBereich(lDaleDocument, lModel.getAbsModel());
            PartModelBuilder.fuelleNotBereich(lDaleDocument, lModel.getNotModel());
        }
        catch (UniDavDocumentException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        return lModel;
    }

    private void fuelleHauptteil(DaleDocument aDocument, VEEBReportModelSubreport aModel) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        int summeAss1 = 0;
        int summeAss2 = 0;
        int summeAss3 = 0;
        int summeAss4 = 0;
        try {
            summeAss1 = Integer.parseInt(aModel.getAss1_Geschlecht().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            summeAss2 = Integer.parseInt(aModel.getAss2_Alter().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            summeAss3 = Integer.parseInt(aModel.getAss3_Inhalationstrauma().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            summeAss4 = Integer.parseInt(aModel.getAss4_DrittgradigeVerbrennung().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String ueberTrag = String.valueOf(summeAss1 + summeAss2 + summeAss3 + summeAss4);
        aModel.setKontxt_UebertragAss1234(ueberTrag);
        Enumeration<DaleSegment> lVerSegments = aDocument.getSegments("ver");
        while (lVerSegments.hasMoreElements()) {
            DaleSegment lVerSegment = lVerSegments.nextElement();
            VerbrennungModel lVerbrennungModel = this.getVerbrennungModel(lVerSegment.getString("ver_20"), aModel);
            ModelBuilderUtils.uebertrageWerte((Object)lVerbrennungModel, lVerSegment, "ver");
        }
        aModel.getVerbrennungGrad2A().setSvb1234_Summe(aDocument.getString("svb", "svb_1"));
        aModel.getVerbrennungGrad2B().setSvb1234_Summe(aDocument.getString("svb", "svb_2"));
        aModel.getVerbrennungGrad3().setSvb1234_Summe(aDocument.getString("svb", "svb_3"));
        aModel.getVerbrennungGrad4().setSvb1234_Summe(aDocument.getString("svb", "svb_4"));
    }

    private VerbrennungModel getVerbrennungModel(String aGrad, VEEBReportModelSubreport aModel) {
        switch (aGrad) {
            case "1": {
                return aModel.getVerbrennungGrad2A();
            }
            case "2": {
                return aModel.getVerbrennungGrad2B();
            }
            case "3": {
                return aModel.getVerbrennungGrad3();
            }
            case "4": {
                return aModel.getVerbrennungGrad4();
            }
        }
        return aModel.getVerbrennungGrad2A();
    }
}

