/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.model.dale.MAHBReportModel;
import dguv.daleuv.report.model.dale.MAHBReportModelSubreport;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.PartModelBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.document.UniDavDocumentException;

public class MAHB_ReportModelBuilder
extends DaleAbstractReportModelBuilder {
    public MAHB_ReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        super(aNachrichtentyp);
    }

    @Override
    public ReportModel buildModel(GVContext aGVContext) {
        MAHBReportModel lModel = new MAHBReportModel();
        lModel.setKontext_BerichtsArt(this.getBerichtsArt());
        try {
            this.fuelleKopfUndFussZeile(aGVContext, lModel);
            lModel.getKopfbereichModel().setKontext_BerichtsArt(this.getBerichtsArt());
            PartModelBuilder.fuelleDabeMasterKopfBereich(aGVContext, lModel.getKopfbereichModel(), "Mitteilung Arbeitsf\u00e4higkeit/Abschluss besondere Heilbehandlung");
            DaleDocument lDaleDocument = (DaleDocument)aGVContext.getUniDavDocument();
            this.fuelleHauptteil(lDaleDocument, lModel.getMahbReportModelSubreport());
            PartModelBuilder.fuelleAbsBereich(lDaleDocument, lModel.getAbsModel());
            PartModelBuilder.fuelleNotBereich(lDaleDocument, lModel.getNotModel());
        }
        catch (UniDavDocumentException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        return lModel;
    }

    private void fuelleHauptteil(DaleDocument aDocument, MAHBReportModelSubreport aModel) throws UniDavDocumentException {
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        switch (aDocument.getString("kdi", "kdi_19")) {
            case "2": {
                aModel.setKdi819_MinderungDerErw(aDocument.getString("kdi", "kdi_8"));
                break;
            }
            case "1": {
                aModel.setKdi819_MinderungDerErw("< 10");
                break;
            }
            default: {
                aModel.setKdi819_MinderungDerErw("0");
            }
        }
        aModel.setKdi1011141213_AnschriftAndererArzt(ModelBuilderUtils.formatAnschrift(aDocument.getString("kdi", "kdi_10"), aDocument.getString("kdi", "kdi_11"), aDocument.getString("kdi", "kdi_14"), aDocument.getString("kdi", "kdi_12"), aDocument.getString("kdi", "kdi_13")));
    }
}

