/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.client.xml;

import dguv.daleuv.report.client.xml.XmlException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import oracle.xml.parser.v2.DOMParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class StandaloneXmlParserFactory {
    public DOMParser createOracleDomParser() {
        DOMParser lParser = new DOMParser();
        lParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)Boolean.FALSE);
        lParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", (Object)Boolean.FALSE);
        return lParser;
    }

    public SAXParser createSaxParser() {
        return this.createSaxParser(null);
    }

    public SAXParser createSaxParser(Schema aSchema) {
        SAXParserFactory lFactory = SAXParserFactory.newInstance();
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            lFactory.setFeature(FEATURE, true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            lFactory.setFeature(FEATURE, false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            lFactory.setFeature(FEATURE, false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        try {
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            lFactory.setFeature(FEATURE, false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        lFactory.setXIncludeAware(false);
        if (aSchema != null) {
            lFactory.setSchema(aSchema);
        }
        try {
            return lFactory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new XmlException("Fehler beim Erzeugen des Parsers!", e);
        }
    }

    public XMLReader createXmlReader() {
        try {
            XMLReader lXmlReader = XMLReaderFactory.createXMLReader();
            lXmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            lXmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            lXmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return lXmlReader;
        }
        catch (SAXException e) {
            throw new XmlException("Fehler beim Erzeugen des Parsers!", e);
        }
    }

    public DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory lFactory = DocumentBuilderFactory.newInstance();
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            lFactory.setFeature(FEATURE, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            lFactory.setFeature(FEATURE, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            lFactory.setFeature(FEATURE, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            lFactory.setFeature(FEATURE, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        lFactory.setXIncludeAware(false);
        lFactory.setExpandEntityReferences(false);
        try {
            return lFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("Fehler beim Erzeugen des Parsers!", e);
        }
    }

    public SAXSource createSaxSource(InputStream aXmlInputStream) {
        return this.createSaxSource(aXmlInputStream, null);
    }

    public SAXSource createSaxSource(InputStream aXmlInputStream, Schema aSchema) {
        XMLReader xmlReader;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new XmlException("Feature disallow-doctype-decl konnte nicht gesetzt werden!", e);
        }
        if (aSchema != null) {
            spf.setSchema(aSchema);
        }
        spf.setNamespaceAware(true);
        try {
            xmlReader = spf.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new XmlException("Fehler beim Erzeugen des XMLReaders!", e);
        }
        SAXSource xmlSource = new SAXSource(xmlReader, new InputSource(aXmlInputStream));
        return xmlSource;
    }
}

