/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.client.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.common.document.DaleSegment;
import dguv.daleuv.common.document.impl.DaleSegmentImpl;
import dguv.daleuv.report.client.xml.StandaloneXmlParserFactory;
import dguv.unidav.common.dao.PostAdresse;
import dguv.unidav.common.document.UniDavDocumentException;
import dguv.unidav.common.document.impl.UniDavDocumentImpl;
import dguv.unidav.common.utils.DateTimeHelper;
import java.io.ByteArrayInputStream;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandaloneDaleDocumentImpl
extends UniDavDocumentImpl
implements DaleDocument {
    private static final long serialVersionUID = 2874272622934422758L;
    private static final List<String> mDaleNtypArray = Arrays.asList("DABE", "VERB", "MAHB", "RE13", "ABRZ", "KOEB", "KNEB", "SUEB", "VEEB");
    private XMLDocument doc = null;
    private XMLElement rootElement = null;
    private String rootTagName = null;
    private TreeMap<String, TreeMap<String, String>> mEnumTextMap;
    private String mAbsenderName;
    private PostAdresse mVersandAdresseGKV;
    private boolean mNoXmlSchemaValdation = false;

    public StandaloneDaleDocumentImpl(String aNtyp, String aNtypVersion, byte[] aXML, boolean aNoSchemaValidation) throws UniDavDocumentException {
        super(aNtyp, aNtypVersion, aXML);
        this.mNoXmlSchemaValdation = aNoSchemaValidation;
        this.initialize();
        this.parseDocument(aXML, aNtyp);
    }

    private void initialize() {
        if (this.getNtyp().equals("ABGA")) {
            this.mEnumTextMap = new TreeMap();
        }
        this.rootTagName = this.getNtyp().substring(0, 4).toLowerCase() + "_file";
    }

    private void parseDocument(byte[] aXML, String aNtyp) throws UniDavDocumentException {
        try {
            StandaloneXmlParserFactory lParserFactory = new StandaloneXmlParserFactory();
            DOMParser lParser = lParserFactory.createOracleDomParser();
            lParser.setErrorStream(System.err);
            lParser.showWarnings(true);
            lParser.setValidationMode(0);
            lParser.parse(new ByteArrayInputStream(aXML));
            this.doc = lParser.getDocument();
            this.rootElement = (XMLElement)this.doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    private XMLSchema getSchema() throws XSDException {
        XSDBuilder lXsdBulder = new XSDBuilder();
        InputSource inputSource = new InputSource(this.getClass().getClassLoader().getResourceAsStream("dguv/daleuv/common/document/validation/dale.xsd"));
        return lXsdBulder.build(inputSource);
    }

    private boolean isDaleNtyp(String aNtyp) {
        return mDaleNtypArray.contains(aNtyp.toUpperCase());
    }

    @Override
    public Enumeration<DaleSegment> getSegments(String aSegmentName) throws UniDavDocumentException {
        NodeList lNodeList = this.doc.getElementsByTagName(aSegmentName);
        Vector<DaleSegmentImpl> lSegmentList = new Vector<DaleSegmentImpl>();
        for (int i = 0; i < lNodeList.getLength(); ++i) {
            Node lNode = lNodeList.item(i);
            if (!(lNode instanceof XMLElement)) continue;
            DaleSegmentImpl lDaleSegment = new DaleSegmentImpl((XMLElement)lNode);
            lSegmentList.add(lDaleSegment);
        }
        return lSegmentList.elements();
    }

    @Override
    public String getString(String aSegmentName, String aElementName) throws UniDavDocumentException {
        try {
            NodeList lNodeList = this.rootElement.selectNodes(this.getSelectPatternFor(aSegmentName, aElementName), this.rootElement);
            if (lNodeList.getLength() > 0) {
                return lNodeList.item(0).getNodeValue().trim();
            }
            return "";
        }
        catch (XSLException e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getInteger(String aSegmentName, String aElementName) throws UniDavDocumentException {
        String lValue = this.getString(aSegmentName, aElementName);
        if (lValue != null && lValue.length() > 0) {
            return new Integer(lValue);
        }
        return null;
    }

    @Override
    public Date getDate(String aSegmentName, String aElementName) throws UniDavDocumentException {
        return this.getDate(aSegmentName, aElementName, "dd.MM.yyyy");
    }

    @Override
    public Date getDate(String aSegmentName, String aElementName, String aMaske) throws UniDavDocumentException {
        try {
            String lValue = this.getString(aSegmentName, aElementName);
            if (lValue != null && lValue.length() > 0) {
                return DateTimeHelper.getDateFrom(lValue, aMaske);
            }
            return null;
        }
        catch (ParseException e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public Time getTime(String aSegmentName, String aElementName) throws UniDavDocumentException {
        try {
            String lValue = this.getString(aSegmentName, aElementName);
            if (lValue != null && lValue.length() > 0) {
                return DateTimeHelper.getTimeFrom(lValue, "HH.mm");
            }
            return null;
        }
        catch (ParseException e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public Document getNativeDocument() throws UniDavDocumentException {
        return this.doc;
    }

    @Override
    public PostAdresse getVersandAdresseGKV() {
        return this.mVersandAdresseGKV;
    }

    @Override
    public void setVersandAdresseGKV(PostAdresse aAdresse) {
        this.mVersandAdresseGKV = aAdresse;
    }

    private String getSelectPatternFor(String aSegmentName, String aElementName) {
        StringBuffer lSelectPattern = new StringBuffer("/");
        lSelectPattern.append(this.rootTagName).append("/");
        if (!aSegmentName.startsWith("unb")) {
            lSelectPattern.append(this.getNtyp().substring(0, 4).toLowerCase()).append("/");
        }
        lSelectPattern.append(aSegmentName).append("/");
        lSelectPattern.append(aElementName).append("/");
        lSelectPattern.append("text()");
        return lSelectPattern.toString();
    }

    @Override
    public String getAbsName() {
        if (this.mAbsenderName == null) {
            return "";
        }
        return this.mAbsenderName;
    }

    @Override
    public void setAbsName(String aAbsenderName) {
        this.mAbsenderName = aAbsenderName;
    }

    @Override
    public String getTextFor(String aTagname, String aValue) {
        if (this.mEnumTextMap == null) {
            return "";
        }
        TreeMap<String, String> lWertTextMap = this.mEnumTextMap.get(aTagname);
        if (lWertTextMap == null) {
            return "";
        }
        String lText = lWertTextMap.get(aValue);
        if (lText == null) {
            return "";
        }
        return lText;
    }

    public void setEnumTextMap(TreeMap<String, TreeMap<String, String>> aEnumTextMap) {
        this.mEnumTextMap = aEnumTextMap;
    }

    public static String plzKorrektur(String aPlz, String aLand) {
        String lPlz;
        String lLaenderkennung = "DE";
        if (aLand != null && !"".equalsIgnoreCase(aLand.trim())) {
            if ("unb".equalsIgnoreCase(aLand.trim())) {
                lLaenderkennung = null;
            } else {
                lLaenderkennung = aLand.trim();
                if ("".equalsIgnoreCase(lLaenderkennung) || "D".equalsIgnoreCase(lLaenderkennung) || "DE".equalsIgnoreCase(lLaenderkennung) || "DEU".equalsIgnoreCase(lLaenderkennung)) {
                    lLaenderkennung = "DE";
                }
            }
        }
        if (aPlz != null && !"".equals(aPlz.trim()) && "DE".equalsIgnoreCase(lLaenderkennung) && (lPlz = aPlz.trim()).length() == 4 && !lPlz.startsWith("0")) {
            return '0' + lPlz;
        }
        return aPlz;
    }
}

