/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.client;

import dguv.daleuv.report.client.io.OutputFile;
import dguv.daleuv.report.client.test.Candidate;
import dguv.daleuv.report.client.test.Examiner;
import dguv.daleuv.report.client.xml.ConfigService;
import java.io.File;

public class Dale2Pdf
implements Candidate {
    private static final String VERSION = "6.0.2";
    private String[] args = null;
    private int fileIndex = -1;
    private static boolean generateDefault = true;
    private static boolean generateGKV = false;
    private static boolean generateWBA = false;
    private int pathIndex = -1;

    public Dale2Pdf(String[] aArgs) {
        this.args = aArgs;
        generateWBA = false;
        generateGKV = false;
        generateDefault = true;
    }

    private static void info() {
        System.out.println("\n*****************************************************************");
        System.out.println("Titel: DALE-UV PDF-Generator");
        System.out.println("Organisation: DGUV");
        System.out.println("Anwendung: Erzeugung DALE-UV PDF aus DALE-UV XML");
        System.out.println("Version: 6.0.2");
        System.out.println("JRE-Version: " + System.getProperty("java.version"));
        System.out.println("*****************************************************************");
        System.out.println("");
    }

    private static void usage() {
        System.out.println("Aufruf: [PDF_GENERATOR_APP] -i <Pfad>/Dateiname[.xml] -o <Ausgabepfad> [-g] [-w] [-s]");
        System.out.println("\t-i: Pfad und Dateiname des DALE-UV XML-Dokuments");
        System.out.println("\t-o: Verzeichnis, in dem die PDF-Datei erzeugt werden soll");
        System.out.println("\t-g: Erzeugung der Berichtsversion fuer die gesetzl. Krankenversicherung");
        System.out.println("\t-w: Erzeugung der Berichtsversion fuer den weiterbeh. Arzt / Konsiliararzt");
        System.out.println("\t-s: keine Erzeugung der Standardberichtsversion (UV-Traeger)");
        System.exit(1);
    }

    public void createPdf() throws Exception {
        Examiner lExaminer = new Examiner();
        lExaminer.registerCandidate(this);
        lExaminer.examine(this);
        lExaminer.removeCandidate(this);
        OutputFile lOutputFile = new OutputFile(this.getInputFile(), this.getOutputPath(), generateDefault, generateGKV, generateWBA);
        lExaminer.registerCandidate(lOutputFile);
        lExaminer.registerCandidate(ConfigService.getInstance());
        lExaminer.examineAll();
        lOutputFile.out();
    }

    public static void main(String[] args) {
        try {
            Dale2Pdf.info();
            Dale2Pdf lDale2Pdf = new Dale2Pdf(args);
            lDale2Pdf.createPdf();
        }
        catch (Throwable e) {
            try {
                if (e.getMessage().equals("0001") || e.getMessage().equals("0002") || e.getMessage().equals("0003")) {
                    Dale2Pdf.usage();
                } else {
                    System.err.println(ConfigService.getInstance().getMessage(e));
                }
            }
            catch (Exception ex) {
                e.printStackTrace();
            }
            finally {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    private File getInputFile() {
        return new File(this.args[this.fileIndex]);
    }

    private File getOutputPath() {
        return new File(this.args[this.pathIndex]);
    }

    @Override
    public void examine() throws Exception {
        if (this.args.length < 4 || this.args.length > 7) {
            throw new Exception("0003");
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (i < this.args.length - 1 && this.args[i].equals("-i")) {
                this.fileIndex = ++i;
                continue;
            }
            if (i < this.args.length - 1 && this.args[i].equals("-o")) {
                this.pathIndex = ++i;
                continue;
            }
            if (this.args[i].equals("-s")) {
                generateDefault = false;
                continue;
            }
            if (this.args[i].equals("-g")) {
                generateGKV = true;
                continue;
            }
            if (this.args[i].equals("-w")) {
                generateWBA = true;
                continue;
            }
            throw new Exception("0004");
        }
        if (this.fileIndex == -1) {
            throw new Exception("0001");
        }
        if (this.pathIndex == -1) {
            throw new Exception("0002");
        }
        if (!(generateDefault || generateGKV || generateWBA)) {
            throw new Exception("0005");
        }
    }
}

