/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report;

import dguv.daleuv.report.BuilderPackage;
import dguv.daleuv.report.ReportModelBuilder;
import dguv.unidav.common.dao.Nachrichtentyp;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ReportModelBuilderFactory {
    private static ReportModelBuilderFactory mInstance = new ReportModelBuilderFactory();

    public static ReportModelBuilderFactory getInstance() {
        return mInstance;
    }

    protected ReportModelBuilderFactory() {
    }

    public <T extends ReportModelBuilder> T getModelBuilder(Nachrichtentyp aNachrichtentyp, BuilderPackage aPackageName) {
        Class<? extends ReportModelBuilder> lBuilderClass = null;
        boolean lZusatzBericht = aNachrichtentyp.getTyp().endsWith("_GKV") || aNachrichtentyp.getTyp().endsWith("_WBA") || aNachrichtentyp.getTyp().endsWith("_KON");
        lBuilderClass = this.sucheNachBuilderKlasse(lBuilderClass, aPackageName.getPackageName() + "." + aNachrichtentyp.getTyp() + "_" + aNachrichtentyp.getFormKennung() + "_ReportModelBuilder");
        if (lZusatzBericht) {
            lBuilderClass = this.sucheNachBuilderKlasse(lBuilderClass, aPackageName.getPackageName() + "." + aNachrichtentyp.getTyp().substring(0, aNachrichtentyp.getTyp().length() - 4) + "_" + aNachrichtentyp.getFormKennung() + "_ReportModelBuilder");
        }
        lBuilderClass = this.sucheNachBuilderKlasse(lBuilderClass, aPackageName.getPackageName() + "." + aNachrichtentyp.getTyp() + "_ReportModelBuilder");
        if (lZusatzBericht) {
            lBuilderClass = this.sucheNachBuilderKlasse(lBuilderClass, aPackageName.getPackageName() + "." + aNachrichtentyp.getTyp().substring(0, aNachrichtentyp.getTyp().length() - 4) + "_ReportModelBuilder");
        }
        if (lBuilderClass == null) {
            throw new IllegalArgumentException("Model Builder nicht gefunden f\u00fcr Nachrichtentyp " + aNachrichtentyp.getTyp());
        }
        try {
            Constructor<? extends ReportModelBuilder> constructor = lBuilderClass.getConstructor(Nachrichtentyp.class);
            return (T)constructor.newInstance(aNachrichtentyp);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Konstruktor nicht gefunden " + lBuilderClass, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Instanziierung fehlgeschlagen " + lBuilderClass, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Instanziierung fehlgeschlagen " + lBuilderClass, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Instanziierung fehlgeschlagen " + lBuilderClass, e);
        }
    }

    private Class<? extends ReportModelBuilder> sucheNachBuilderKlasse(Class<? extends ReportModelBuilder> aKlasse, String aKlassenName) {
        if (aKlasse != null) {
            return aKlasse;
        }
        try {
            return Class.forName(aKlassenName).asSubclass(ReportModelBuilder.class);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            return null;
        }
    }
}

