/*
 * Decompiled with CFR 0.152.
 */
package de.dguv.generator;

import de.dguv.dto.Formular;
import de.dguv.exception.DguvJasperException;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBasePrintLine;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;

public class IReportGenerator {
    private JasperPrint mFullJasperPrint = null;
    private JasperPrint mSingleJasperPrint = null;
    private JasperPrint mBlankPage = null;
    private String mPfadReport = null;
    private String mPfadSubreport = null;
    private boolean mDuplexPrinting = false;
    private String mMetaDataCreator = null;
    private String mMetaDataAuthor = null;
    private String mMetaDataKeywords = null;
    private String mMetaDataTitle = null;
    private String mMetaDataSubject = null;
    private String mCouvertierungTyp = null;
    private boolean mCouvertierungVerpacken = true;
    private int mSequentLfdNr = -1;
    private HashMap<String, JRPrintLine> mOMRStrich = new HashMap();
    private HashMap<String, Integer> mPosY = new HashMap();
    private static final String kouvStart = "start";
    private static final String kouvsammel = "sammel";
    private static final String kouvseq1 = "1";
    private static final String kouvseq2 = "2";
    private static final String kouvseq3 = "3";
    private static final String kouvparitaet = "par";
    private static final String kouvende = "ende";
    private JRPdfExporter mPdfExporter = new JRPdfExporter();

    public IReportGenerator() {
        this.mOMRStrich.clear();
        this.mSequentLfdNr = -1;
        this.mPosY.clear();
        this.mPdfExporter = new JRPdfExporter();
    }

    public void setPfadReport(String aPfadReport) {
        this.mPfadReport = aPfadReport;
    }

    public void setPfadSubreport(String aPfadSubreport) {
        this.mPfadSubreport = aPfadSubreport;
    }

    public void setMetaDataToDocument(Formular aFormular) {
        this.mMetaDataCreator = aFormular.getMetaDataCreator();
        this.mMetaDataAuthor = aFormular.getMetaDataAuthor();
        this.mMetaDataKeywords = aFormular.getMetaDataKeywords();
        this.mMetaDataTitle = aFormular.getMetaDataTitle();
        this.mMetaDataSubject = aFormular.getMetaDataSubject();
    }

    public void setCouvertierungTyp(String aCouvertierungTyp) {
        this.mCouvertierungTyp = aCouvertierungTyp;
        this.mSequentLfdNr = -1;
        this.mCouvertierungVerpacken = true;
    }

    public void setCouvertierungVerpacken(boolean aCouvertierungVerpacken) {
        this.mCouvertierungVerpacken = aCouvertierungVerpacken;
    }

    public void resetOutput() {
        this.mFullJasperPrint = null;
        this.mSingleJasperPrint = null;
        this.mSequentLfdNr = -1;
    }

    public void fillLeerformularHashMapAddOutput(JasperReport aLeerformular, Map<String, Object> aLeerformuarWerte) throws DguvJasperException {
        this.mSingleJasperPrint = null;
        try {
            this.mSingleJasperPrint = JasperFillManager.fillReport(aLeerformular, aLeerformuarWerte, (JRDataSource)new JREmptyDataSource());
            this.abschlussSingleJasperPrint();
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares ist ein Fehler aufgetreten: fillLeerformularHashMapAddOutput";
            throw new DguvJasperException(djeFehlermeldung, e);
        }
    }

    public void fillLeerformularHashMapAddSingle(String aTeilformularFunction, JasperReport aLeerformular, Map<String, Object> aLeerformuarWerte) throws DguvJasperException {
        if (aTeilformularFunction.equalsIgnoreCase("INIT")) {
            this.mSingleJasperPrint = null;
        }
        JasperPrint lSingleJasperPrint = null;
        try {
            lSingleJasperPrint = JasperFillManager.fillReport(aLeerformular, aLeerformuarWerte, (JRDataSource)new JREmptyDataSource());
            this.addToSingleJasperPrint(lSingleJasperPrint);
            if (aTeilformularFunction.equalsIgnoreCase("END")) {
                this.abschlussSingleJasperPrint();
                this.mSingleJasperPrint = null;
            }
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares ist ein Fehler aufgetreten: fillLeerformularHashMapAddSingle";
            throw new DguvJasperException(djeFehlermeldung, e);
        }
    }

    public void fillLeerformularCollectionAddOutput(JasperReport aLeerformular, Object aReportModel) throws DguvJasperException {
        this.mSingleJasperPrint = new JasperPrint();
        try {
            List<Object> lModelList = Collections.singletonList(aReportModel);
            JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(lModelList);
            this.mSingleJasperPrint = JasperFillManager.fillReport(aLeerformular, null, (JRDataSource)beanColDataSource);
            this.abschlussSingleJasperPrint();
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares aus einer Datenbean ist ein Fehler aufgetreten: fillLeerformularCollectionAddOutput";
            throw new DguvJasperException(djeFehlermeldung, e);
        }
    }

    public void fillLeerformularCollectionAddSingle(String aTeilformularFunction, JasperReport aLeerformular, Object aReportModel) throws DguvJasperException {
        if (aTeilformularFunction.equalsIgnoreCase("INIT")) {
            this.mSingleJasperPrint = null;
        }
        JasperPrint lSingleJasperPrint = null;
        try {
            List<Object> lModelList = Collections.singletonList(aReportModel);
            JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(lModelList);
            lSingleJasperPrint = JasperFillManager.fillReport(aLeerformular, null, (JRDataSource)beanColDataSource);
            this.addToSingleJasperPrint(lSingleJasperPrint);
            if (aTeilformularFunction.equalsIgnoreCase("END")) {
                this.abschlussSingleJasperPrint();
                this.mSingleJasperPrint = null;
            }
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares aus einer Datenbean ist ein Fehler aufgetreten: fillLeerformularCollectionAddOutput: fillLeerformularCollectionAddSingle";
            throw new DguvJasperException(djeFehlermeldung, e);
        }
    }

    public void fillLeerformularSRCollectionAddOutput(String nameSerienbrief, Object aReportModel) throws DguvJasperException {
        this.mSingleJasperPrint = null;
        HashMap<String, Object> lParameterMapReport = new HashMap<String, Object>();
        lParameterMapReport.put("SUBREPORT_DIR", this.mPfadSubreport);
        JasperReport jasperReport = this.getLeerformularFromFile(nameSerienbrief);
        try {
            List<Object> lModelList = Collections.singletonList(aReportModel);
            JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(lModelList);
            this.mSingleJasperPrint = JasperFillManager.fillReport(jasperReport, lParameterMapReport, (JRDataSource)beanColDataSource);
            this.abschlussSingleJasperPrint();
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares aus einer Datenbean ist ein Fehler aufgetreten: fillLeerformularSRCollectionAddOutput";
            throw new DguvJasperException(djeFehlermeldung, e);
        }
    }

    public void fillLeerformularSRCollectionAddSingle(String aTeilformularFunction, String nameSerienbrief, Object aReportModel) throws DguvJasperException {
        if (aTeilformularFunction.equalsIgnoreCase("INIT")) {
            this.mSingleJasperPrint = null;
        }
        JasperPrint lSingleJasperPrint = null;
        HashMap<String, Object> lParameterMapReport = new HashMap<String, Object>();
        lParameterMapReport.put("SUBREPORT_DIR", this.mPfadSubreport);
        JasperReport jasperReport = this.getLeerformularFromFile(nameSerienbrief);
        try {
            List<Object> lModelList = Collections.singletonList(aReportModel);
            JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(lModelList);
            lSingleJasperPrint = JasperFillManager.fillReport(jasperReport, lParameterMapReport, (JRDataSource)beanColDataSource);
            this.addToSingleJasperPrint(lSingleJasperPrint);
            if (aTeilformularFunction.equalsIgnoreCase("END")) {
                this.abschlussSingleJasperPrint();
                this.mSingleJasperPrint = null;
            }
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares aus einer Datenbean ist ein Fehler aufgetreten: fillLeerformularCollectionAddOutput: fillLeerformularCollectionAddSingle";
            throw new DguvJasperException(djeFehlermeldung, e);
        }
    }

    public ByteArrayOutputStream fillLeerformularSRCollectionDirectOutput(String nameSerienbrief, Object aReportModel) throws DguvJasperException {
        JasperPrint lJasperPrint = null;
        HashMap<String, Object> lParameterMapReport = new HashMap<String, Object>();
        lParameterMapReport.put("SUBREPORT_DIR", this.mPfadSubreport);
        JasperReport jasperReport = this.getLeerformularFromFile(nameSerienbrief);
        try {
            List<Object> lModelList = Collections.singletonList(aReportModel);
            JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource(lModelList);
            lJasperPrint = JasperFillManager.fillReport(jasperReport, lParameterMapReport, (JRDataSource)beanColDataSource);
        }
        catch (JRException e) {
            String djeFehlermeldung = "Beim F\u00fcllen des Formulares aus einer Datenbean ist ein Fehler aufgetreten: fillLeerformularSRCollectionDirectOutput" + e;
            throw new DguvJasperException(djeFehlermeldung, e);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, lJasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, outputStream);
        exporter.setParameter(JRPdfExporterParameter.METADATA_CREATOR, this.mMetaDataCreator);
        exporter.setParameter(JRPdfExporterParameter.METADATA_AUTHOR, this.mMetaDataAuthor);
        exporter.setParameter(JRPdfExporterParameter.METADATA_KEYWORDS, this.mMetaDataKeywords);
        exporter.setParameter(JRPdfExporterParameter.METADATA_TITLE, this.mMetaDataTitle);
        exporter.setParameter(JRPdfExporterParameter.METADATA_SUBJECT, this.mMetaDataSubject);
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            String djeFehlermeldung = "JR-Fehler beim Export als ByteArrayOutputStream: fillLeerformularSRCollectionDirectOutput";
            throw new DguvJasperException(djeFehlermeldung, this.createPseudoJRException());
        }
        return outputStream;
    }

    public void abschlussSingleJasperPrint() throws DguvJasperException {
        if (this.isDuplexPrinting() && this.mSingleJasperPrint.getPages().size() % 2 != 0) {
            this.addSingleFormularEmtpyPage();
        }
        if (this.mCouvertierungTyp != null) {
            this.addKouvertierung();
        }
        this.addToFullJasperPrint(this.mSingleJasperPrint);
    }

    public JasperReport getLeerformularFromFile(String nameSerienbrief) throws DguvJasperException {
        JasperReport jasperReport = null;
        String jasperPfad = this.mPfadReport + nameSerienbrief + ".jasper";
        InputStream inputStream = IReportGenerator.class.getClassLoader().getResourceAsStream(jasperPfad);
        if (inputStream == null) {
            String djeFehlermeldung = "Das Leerformulare konnte nicht gelesen werden: " + jasperPfad;
            throw new DguvJasperException(djeFehlermeldung, this.createPseudoJRException());
        }
        try {
            jasperReport = (JasperReport)JRLoader.loadObject(inputStream);
        }
        catch (JRException e) {
            String djeFehlermeldung = "Das Leerformulare konnte nicht gelesen werden: " + jasperPfad;
            throw new DguvJasperException(djeFehlermeldung, e);
        }
        return jasperReport;
    }

    private void addToSingleJasperPrint(JasperPrint aJasperPrint) {
        if (aJasperPrint != null) {
            if (this.mSingleJasperPrint == null) {
                this.mSingleJasperPrint = aJasperPrint;
            } else {
                for (JRPrintPage page : aJasperPrint.getPages()) {
                    this.mSingleJasperPrint.addPage(page);
                }
            }
        }
    }

    private void addToFullJasperPrint(JasperPrint aJasperPrint) {
        if (aJasperPrint != null) {
            if (this.mFullJasperPrint == null) {
                this.mFullJasperPrint = aJasperPrint;
            } else {
                for (JRPrintPage page : aJasperPrint.getPages()) {
                    this.mFullJasperPrint.addPage(page);
                }
            }
        }
    }

    public String createSerienbriefeAsFile(String aFilenamePrefix) throws DguvJasperException {
        File exportFile = null;
        String exportFilename = null;
        try {
            if (this.mFullJasperPrint == null) {
                String ioFehlermeldung = "Das zu erstellende PDF-Dokument ist leer: createSerienbriefeAsFile";
                throw new DguvJasperException(ioFehlermeldung, this.createPseudoJRException());
            }
            exportFile = File.createTempFile(aFilenamePrefix, ".pdf");
            this.mPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, this.mFullJasperPrint);
            this.mPdfExporter.setParameter(JRXlsExporterParameter.OUTPUT_FILE, exportFile);
            this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_CREATOR, this.mMetaDataCreator);
            this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_AUTHOR, this.mMetaDataAuthor);
            this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_KEYWORDS, this.mMetaDataKeywords);
            this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_TITLE, this.mMetaDataTitle);
            this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_SUBJECT, this.mMetaDataSubject);
            this.mPdfExporter.exportReport();
            exportFilename = exportFile.getPath();
        }
        catch (IOException e) {
            String ioFehlermeldung = "IO-Fehler beim erstellen der tempor\u00e4ren Datei: createSerienbriefeAsFile";
            throw new DguvJasperException(ioFehlermeldung, this.createPseudoJRException());
        }
        catch (JRException e) {
            String djeFehlermeldung = "JR-Fehler beim Export als tempor\u00e4re Datei: createSerienbriefeAsFile";
            throw new DguvJasperException(djeFehlermeldung, this.createPseudoJRException());
        }
        return exportFilename;
    }

    public ByteArrayOutputStream createSerienbriefeAsOutputStream() throws DguvJasperException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, this.mFullJasperPrint);
        this.mPdfExporter.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, outputStream);
        this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_CREATOR, this.mMetaDataCreator);
        this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_AUTHOR, this.mMetaDataAuthor);
        this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_KEYWORDS, this.mMetaDataKeywords);
        this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_TITLE, this.mMetaDataTitle);
        this.mPdfExporter.setParameter(JRPdfExporterParameter.METADATA_SUBJECT, this.mMetaDataSubject);
        try {
            this.mPdfExporter.exportReport();
        }
        catch (JRException e) {
            String djeFehlermeldung = "JR-Fehler beim Export als ByteArrayOutputStream: createSerienbriefeAsOutputStream";
            throw new DguvJasperException(djeFehlermeldung, this.createPseudoJRException());
        }
        return outputStream;
    }

    public void setFullJasperPrint(JasperPrint aFullJasperPrint) {
        this.mFullJasperPrint = aFullJasperPrint;
    }

    public void setDuplexPrinting(boolean aDuplexPrinting) {
        this.mDuplexPrinting = aDuplexPrinting;
    }

    public boolean isDuplexPrinting() {
        return this.mDuplexPrinting;
    }

    public void addSingleFormularEmtpyPage() throws DguvJasperException {
        if (this.mBlankPage == null) {
            JasperReport jasperReport = null;
            JasperDesign design = new JasperDesign();
            design.setName("blank");
            try {
                jasperReport = JasperCompileManager.compileReport(design);
                this.mBlankPage = JasperFillManager.fillReport(jasperReport, new HashMap<String, Object>(), (JRDataSource)new JREmptyDataSource());
            }
            catch (JRException e) {
                String djeFehlermeldung = "Fehler beim erstellen einer leeren Seite: ";
                throw new DguvJasperException(djeFehlermeldung, e);
            }
        }
        this.addToSingleJasperPrint(this.mBlankPage);
    }

    private JRException createPseudoJRException() {
        return new JRException("Pseudo JRException");
    }

    private void addKouvertierung() {
        if (this.mCouvertierungTyp == "OMR") {
            if (this.mOMRStrich.size() != 7) {
                this.generateOMRStriche();
            }
            this.addOMRKode();
        }
    }

    private void addOMRKode() {
        boolean printOMRCode = true;
        int anzahlStricheGesetzt = 0;
        int createOMRCode = 1;
        int duplexSteuerung = 1;
        if (this.mDuplexPrinting) {
            duplexSteuerung = -1;
        }
        List<JRPrintPage> lList = this.mSingleJasperPrint.getPages();
        int anzahlPrintPages = lList.size();
        int i = 1;
        for (JRPrintPage page : this.mSingleJasperPrint.getPages()) {
            if (createOMRCode == 1) {
                ++this.mSequentLfdNr;
                if (this.mSequentLfdNr > 7) {
                    this.mSequentLfdNr = 0;
                }
                anzahlStricheGesetzt = 2;
                page.addElement(this.mOMRStrich.get(kouvStart));
                page.addElement(this.mOMRStrich.get(kouvende));
                if (this.mCouvertierungVerpacken) {
                    if (this.mDuplexPrinting) {
                        if (i == anzahlPrintPages - 1) {
                            page.addElement(this.mOMRStrich.get(kouvsammel));
                            ++anzahlStricheGesetzt;
                        }
                    } else if (i == anzahlPrintPages) {
                        page.addElement(this.mOMRStrich.get(kouvsammel));
                        ++anzahlStricheGesetzt;
                    }
                }
                if (this.mSequentLfdNr > 3) {
                    page.addElement(this.mOMRStrich.get(kouvseq1));
                    ++anzahlStricheGesetzt;
                }
                if (this.mSequentLfdNr == 2 || this.mSequentLfdNr == 3 || this.mSequentLfdNr == 6 || this.mSequentLfdNr == 7) {
                    page.addElement(this.mOMRStrich.get(kouvseq2));
                    ++anzahlStricheGesetzt;
                }
                if (this.mSequentLfdNr % 2 != 0) {
                    page.addElement(this.mOMRStrich.get(kouvseq3));
                    ++anzahlStricheGesetzt;
                }
                if (anzahlStricheGesetzt % 2 != 0) {
                    page.addElement(this.mOMRStrich.get(kouvparitaet));
                }
            }
            createOMRCode *= duplexSteuerung;
            ++i;
        }
    }

    private void generateOMRStriche() {
        this.mOMRStrich.clear();
        this.mPosY.clear();
        this.mPosY.put(kouvStart, 580);
        this.mPosY.put(kouvsammel, 592);
        this.mPosY.put(kouvseq1, 604);
        this.mPosY.put(kouvseq2, 616);
        this.mPosY.put(kouvseq3, 628);
        this.mPosY.put(kouvparitaet, 640);
        this.mPosY.put(kouvende, 652);
        JRBasePrintLine jrPrintLineStart = null;
        for (Map.Entry<String, Integer> entry : this.mPosY.entrySet()) {
            jrPrintLineStart = new JRBasePrintLine(this.mSingleJasperPrint.getDefaultStyleProvider());
            jrPrintLineStart.setWidth(20);
            jrPrintLineStart.setHeight(1);
            jrPrintLineStart.setX(25);
            jrPrintLineStart.setY(entry.getValue());
            jrPrintLineStart.setForecolor(Color.BLACK);
            this.mOMRStrich.put(entry.getKey(), jrPrintLineStart);
        }
    }
}

